/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.samples.ui.views;

import com.aptana.core.logging.IdeLog;
import com.aptana.samples.ISampleListener;
import com.aptana.samples.ISamplesManager;
import com.aptana.samples.SamplesPlugin;
import com.aptana.samples.model.IProjectSample;
import com.aptana.samples.model.SamplesReference;
import com.aptana.samples.ui.SamplesUIPlugin;
import com.aptana.samples.ui.views.SamplesViewContentProvider;
import com.aptana.samples.ui.views.SamplesViewLabelProvider;
import com.aptana.ui.util.UIUtils;
import java.util.Collections;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class SamplesView
extends ViewPart {
    public static final String ID = "com.aptana.samples.ui.SamplesView";
    private TreeViewer treeViewer;
    private ISampleListener sampleListener = new ISampleListener(){

        public void sampleAdded(IProjectSample sample) {
            this.refresh();
        }

        public void sampleRemoved(IProjectSample sample) {
            this.refresh();
        }

        private void refresh() {
            UIUtils.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (SamplesView.this.treeViewer != null && !SamplesView.this.treeViewer.getControl().isDisposed()) {
                        SamplesView.this.treeViewer.refresh();
                    }
                }
            });
        }
    };

    public void createPartControl(Composite parent) {
        this.treeViewer = this.createTreeViewer(parent);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.hookContextMenu();
        SamplesView.getSamplesManager().addSampleListener(this.sampleListener);
    }

    public void setFocus() {
    }

    public void dispose() {
        SamplesView.getSamplesManager().removeSampleListener(this.sampleListener);
        super.dispose();
    }

    public void collapseAll() {
        this.treeViewer.collapseAll();
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        final TreeViewer treeViewer = new TreeViewer(parent, 772);
        treeViewer.setContentProvider((IContentProvider)new SamplesViewContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new SamplesViewLabelProvider());
        treeViewer.setInput((Object)SamplesView.getSamplesManager());
        treeViewer.setComparator(new ViewerComparator());
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ICommandService commandService;
                Command command;
                Object element;
                IStructuredSelection thisSelection = (IStructuredSelection)event.getSelection();
                treeViewer.setExpandedState(element, !treeViewer.getExpandedState(element = thisSelection.getFirstElement()));
                if (element instanceof SamplesReference && (command = (commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class)).getCommand("com.aptana.samples.ui.commands.import")) != null) {
                    try {
                        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                        ExecutionEvent ee = new ExecutionEvent(command, Collections.emptyMap(), null, (Object)handlerService.getCurrentState());
                        command.executeWithChecks(ee);
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)SamplesUIPlugin.getDefault(), (Throwable)e);
                    }
                }
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)treeViewer);
        return treeViewer;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    private static ISamplesManager getSamplesManager() {
        return SamplesPlugin.getDefault().getSamplesManager();
    }
}

